@extends('layouts.app')

@php
	if (!empty($status) && $status == 'quotation') {
		$title = __('lang_v1.add_quotation');
	} else if (!empty($status) && $status == 'draft') {
		$title = __('lang_v1.add_draft');
	} else {
		$title = __('sale.add_sale');
	}

	if($sale_type == 'sales_order') {
		$title = __('lang_v1.sales_order');
	}
@endphp

@section('title', $title)

@section('content')
<!-- Content Header (Page header) -->
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">{{$title}} </h1>
</section>
<!-- Main content -->
<section class="content no-print">
<input type="hidden" id="amount_rounding_method" value="{{$pos_settings['amount_rounding_method'] ?? ''}}">
@if(!empty($pos_settings['allow_overselling']))
	<input type="hidden" id="is_overselling_allowed">
@endif
@if(session('business.enable_rp') == 1)
    <input type="hidden" id="reward_point_enabled">
@endif
@if(count($business_locations) > 0)
<div class="row">
	<div class="col-sm-3">
		<div class="form-group">
			<div class="input-group">
				<span class="input-group-addon">
					<i class="fa fa-map-marker"></i>
				</span>
			{!! Form::select('select_location_id', $business_locations, $default_location->id ?? null, ['class' => 'form-control input-sm',
			'id' => 'select_location_id', 
			'required', 'autofocus'], $bl_attributes); !!}
			<span class="input-group-addon">
					@show_tooltip(__('tooltip.sale_location'))
				</span> 
			</div>
		</div>
	</div>
</div>
@endif

@php
	$custom_labels = json_decode(session('business.custom_labels'), true);
	$common_settings = session()->get('business.common_settings');
@endphp
<input type="hidden" id="item_addition_method" value="{{$business_details->item_addition_method}}">
	{!! Form::open(['url' => action([\App\Http\Controllers\SellPosController::class, 'store']), 'method' => 'post', 'id' => 'add_sell_form', 'files' => true ]) !!}
	 @if(!empty($sale_type))
	 	<input type="hidden" id="sale_type" name="type" value="{{$sale_type}}">
	 @endif
	<div class="row">
		<div class="col-md-12 col-sm-12">
			@component('components.widget', ['class' => 'box-solid'])
				{!! Form::hidden('location_id', !empty($default_location) ? $default_location->id : null , ['id' => 'location_id', 'data-receipt_printer_type' => !empty($default_location->receipt_printer_type) ? $default_location->receipt_printer_type : 'browser', 'data-default_payment_accounts' => !empty($default_location) ? $default_location->default_payment_accounts : '']); !!}
                
				@if(!empty($price_groups))
					@if(count($price_groups) > 1)
					    
						<div class="col-sm-4">
							<div class="form-group">
							    {!! Form::label('price_groups', __('Price Groups') . ':*') !!}
								<div class="input-group">
		  									<span class="input-group-addon">
										<i class="fas fa-money-bill-alt"></i>
									</span>
									@php
										reset($price_groups);
										// keep your current default logic
										$selected_price_group = !empty($default_price_group_id) && array_key_exists($default_price_group_id, $price_groups) ? $default_price_group_id : null;
										// add a clickable "Please Select" as empty value
										$price_groups_with_placeholder = ['' => __('messages.please_select')] + $price_groups;
									@endphp
									{!! Form::hidden('hidden_price_group', key($price_groups), ['id' => 'hidden_price_group']) !!}
									{!! Form::select('price_group', $price_groups_with_placeholder, $selected_price_group, ['class' => 'form-control select2', 'id' => 'price_group', 'data-placeholder' => __('messages.please_select')]); !!}
									<span class="input-group-addon">
										@show_tooltip(__('lang_v1.price_group_help_text'))
									</span> 
								</div>
							</div>
						</div>
					@else
						@php
							reset($price_groups);
						@endphp
						{!! Form::hidden('price_group', key($price_groups), ['id' => 'price_group']) !!}
					@endif
				@endif

				{!! Form::hidden('default_price_group', null, ['id' => 'default_price_group']) !!}

				@if(in_array('types_of_service', $enabled_modules) && !empty($types_of_service))
					<div class="col-md-4 col-sm-6">
						<div class="form-group">
							<div class="input-group">
								<span class="input-group-addon">
									<i class="fa fa-external-link-square-alt text-primary service_modal_btn"></i>
								</span>
								{!! Form::select('types_of_service_id', $types_of_service, null, ['class' => 'form-control', 'id' => 'types_of_service_id', 'style' => 'width: 100%;', 'placeholder' => __('lang_v1.select_types_of_service')]); !!}

								{!! Form::hidden('types_of_service_price_group', null, ['id' => 'types_of_service_price_group']) !!}

								<span class="input-group-addon">
									@show_tooltip(__('lang_v1.types_of_service_help'))
								</span> 
							</div>
							<small><p class="help-block hide" id="price_group_text">@lang('lang_v1.price_group'): <span></span></p></small>
						</div>
					</div>
				@endif
				
				@if(in_array('subscription', $enabled_modules))
					<div class="col-md-4 pull-right col-sm-6">
						<div class="checkbox">
							<label>
				              {!! Form::checkbox('is_recurring', 1, false, ['class' => 'input-icheck', 'id' => 'is_recurring']); !!} @lang('lang_v1.subscribe')?
				            </label><button type="button" data-toggle="modal" data-target="#recurringInvoiceModal" class="btn btn-link"><i class="fa fa-external-link"></i></button>@show_tooltip(__('lang_v1.recurring_invoice_help'))
						</div>
					</div>
				@endif
				<div class="clearfix"></div>
				<div class="@if(!empty($commission_agent)) col-sm-3 @else col-sm-4 @endif">
					<div class="form-group">
						{!! Form::label('contact_id', __('contact.customer') . ':*') !!}
						<div class="input-group">
							<span class="input-group-addon">
								<i class="fa fa-user"></i>
							</span>
							<input type="hidden" id="default_customer_id" 
							value="{{ $walk_in_customer['id']}}" >
							<input type="hidden" id="default_customer_name" 
							value="{{ $walk_in_customer['name']}}" >
							<input type="hidden" id="default_customer_balance" value="{{ $walk_in_customer['balance'] ?? ''}}" >
							<input type="hidden" id="default_customer_address" value="{{ $walk_in_customer['shipping_address'] ?? ''}}" >
							@if(!empty($walk_in_customer['price_calculation_type']) && $walk_in_customer['price_calculation_type'] == 'selling_price_group')
								<input type="hidden" id="default_selling_price_group" 
							value="{{ $walk_in_customer['selling_price_group_id'] ?? ''}}" >
							@endif
							{!! Form::select('contact_id', 
								[], null, ['class' => 'form-control mousetrap', 'id' => 'customer_id', 'placeholder' => 'Enter Customer name / phone', 'required']); !!}
							<span class="input-group-btn">
								<button type="button" class="btn btn-default bg-white btn-flat add_new_customer" data-name=""><i class="fa fa-plus-circle text-primary fa-lg"></i></button>
							</span>
						</div>
						<small class="text-danger hide contact_due_text"><strong>@lang('account.customer_due'):</strong> <span></span></small>
					</div>
					<small>
					<strong>
						@lang('lang_v1.billing_address'):
					</strong>
					<div id="billing_address_div">
						{!! $walk_in_customer['contact_address'] ?? '' !!}
					</div>
					<br>
					<strong>
						@lang('lang_v1.shipping_address'):
					</strong>
					<div id="shipping_address_div">
						{{$walk_in_customer['supplier_business_name'] ?? ''}},<br>
						{{$walk_in_customer['name'] ?? ''}},<br>
						{{$walk_in_customer['shipping_address'] ?? ''}}
					</div>					
					</small>
				</div>

				<div class="col-md-4 col-sm-6">
					<div class="form-group">
						{!! Form::label('customer_qr_code', __('lang_v1.customer_qr_code')) !!}
						<div class="input-group">
							<span class="input-group-addon">
								<i class="fa fa-qrcode"></i>
							</span>
							{!! Form::text('customer_qr_code', null, ['class' => 'form-control', 'id' => 'customer_qr_code', 'placeholder' => __('lang_v1.scan_customer_qr_code')]); !!}
							<span class="input-group-btn">
								<button type="button" class="btn btn-default btn-flat" id="customer_qr_code_clear">@lang('lang_v1.clear')</button>
							</span>
						</div>
						<small id="customer_qr_code_error" class="text-danger hide mt-2"></small>
						<small id="customer_qr_code_success" class="text-success hide mt-2"></small>
					</div>
				</div>

				<div class="col-md-3">
		          <div class="form-group">
		            <div class="multi-input">
		            @php
						$is_pay_term_required = !empty($pos_settings['is_pay_term_required']);
					@endphp
		              {!! Form::label('pay_term_number', __('contact.pay_term') . ':') !!} @show_tooltip(__('tooltip.pay_term'))
		              <br/>
		              {!! Form::number('pay_term_number', $walk_in_customer['pay_term_number'], ['class' => 'form-control width-40 pull-left', 'placeholder' => __('contact.pay_term'), 'required' => $is_pay_term_required]); !!}

		              {!! Form::select('pay_term_type', 
		              	['months' => __('lang_v1.months'), 
		              		'days' => __('lang_v1.days')], 
		              		$walk_in_customer['pay_term_type'], 
		              	['class' => 'form-control width-60 pull-left','placeholder' => __('messages.please_select'), 'required' => $is_pay_term_required]); !!}
		            </div>
		          </div>
		        </div>

				@if(!empty($commission_agent))
				@php
					$is_commission_agent_required = !empty($pos_settings['is_commission_agent_required']);
				@endphp
				<div class="col-sm-3">
					<div class="form-group">
					{!! Form::label('commission_agent', __('lang_v1.commission_agent') . ':') !!}
					{!! Form::select('commission_agent', 
								$commission_agent, null, ['class' => 'form-control select2', 'id' => 'commission_agent', 'required' => $is_commission_agent_required]); !!}
					</div>
				</div>
				@endif
				<div class="@if(!empty($commission_agent)) col-sm-3 @else col-sm-4 @endif">
					<div class="form-group">
						{!! Form::label('transaction_date', __('sale.sale_date') . ':*') !!}
						<div class="input-group">
							<span class="input-group-addon">
								<i class="fa fa-calendar"></i>
							</span>
							{!! Form::text('transaction_date', $default_datetime, ['class' => 'form-control', 'readonly', 'required']); !!}
						</div>
					</div>
				</div>
				@if(!empty($status))
					<input type="hidden" name="status" id="status" value="{{$status}}">

					@if(in_array($status, ['draft', 'quotation']))
						<input type="hidden" id="disable_qty_alert">
					@endif
				@else
					<div class="@if(!empty($commission_agent)) col-sm-3 @else col-sm-4 @endif">
    <div class="form-group">
        {!! Form::label('status', __('sale.status') . ':*') !!}
        @php
            // Normalize to array
            if ($statuses instanceof \Illuminate\Support\Collection) {
                $statuses = $statuses->toArray();
            } elseif (!is_array($statuses)) {
                $statuses = (array) $statuses;
            }
            // Remove any key/value labeled "proforma"
            $statuses = array_filter(
                $statuses,
                function ($label, $key) {
                    return strtolower((string)$key) !== 'proforma' && strtolower((string)$label) !== 'proforma';
                },
                ARRAY_FILTER_USE_BOTH
            );
        @endphp
        {!! Form::select('status', $statuses, null, [
            'class' => 'form-control select2',
            'placeholder' => __('messages.please_select'),
            'required'
        ]) !!}
    </div>
</div>

				@endif
				@if($sale_type != 'sales_order')
					<div class="col-sm-3">
						<div class="form-group">
							{!! Form::label('invoice_scheme_id', __('invoice.invoice_scheme') . ':') !!}
							{!! Form::select('invoice_scheme_id', $invoice_schemes, $default_invoice_schemes->id, ['class' => 'form-control select2', 'placeholder' => __('messages.please_select')]); !!}
						</div>
					</div>
				@endif
					@can('edit_invoice_number')
					<div class="col-sm-3">
						<div class="form-group">
							{!! Form::label('invoice_no', $sale_type == 'sales_order' ? __('restaurant.order_no') : __('sale.invoice_no') . ':') !!}
							{!! Form::text('invoice_no', null, ['class' => 'form-control', 'placeholder' => $sale_type == 'sales_order' ? __('restaurant.order_no') : __('sale.invoice_no')]); !!}
							<p class="help-block">@lang('lang_v1.keep_blank_to_autogenerate')</p>
						</div>
					</div>
					@endcan
				
				@php
			        $custom_field_1_label = !empty($custom_labels['sell']['custom_field_1']) ? $custom_labels['sell']['custom_field_1'] : '';

			        $is_custom_field_1_required = !empty($custom_labels['sell']['is_custom_field_1_required']) && $custom_labels['sell']['is_custom_field_1_required'] == 1 ? true : false;

			        $custom_field_2_label = !empty($custom_labels['sell']['custom_field_2']) ? $custom_labels['sell']['custom_field_2'] : '';

			        $is_custom_field_2_required = !empty($custom_labels['sell']['is_custom_field_2_required']) && $custom_labels['sell']['is_custom_field_2_required'] == 1 ? true : false;

			        $custom_field_3_label = !empty($custom_labels['sell']['custom_field_3']) ? $custom_labels['sell']['custom_field_3'] : '';

			        $is_custom_field_3_required = !empty($custom_labels['sell']['is_custom_field_3_required']) && $custom_labels['sell']['is_custom_field_3_required'] == 1 ? true : false;

			        $custom_field_4_label = !empty($custom_labels['sell']['custom_field_4']) ? $custom_labels['sell']['custom_field_4'] : '';

			        $is_custom_field_4_required = !empty($custom_labels['sell']['is_custom_field_4_required']) && $custom_labels['sell']['is_custom_field_4_required'] == 1 ? true : false;
		        @endphp
		        @if(!empty($custom_field_1_label))
		        	@php
		        		$label_1 = $custom_field_1_label . ':';
		        		if($is_custom_field_1_required) {
		        			$label_1 .= '*';
		        		}
		        	@endphp

		        	<div class="col-md-4">
				        <div class="form-group">
				            {!! Form::label('custom_field_1', $label_1 ) !!}
				            {!! Form::text('custom_field_1', null, ['class' => 'form-control','placeholder' => $custom_field_1_label, 'required' => $is_custom_field_1_required]); !!}
				        </div>
				    </div>
		        @endif
		        @if(!empty($custom_field_2_label))
		        	@php
		        		$label_2 = $custom_field_2_label . ':';
		        		if($is_custom_field_2_required) {
		        			$label_2 .= '*';
		        		}
		        	@endphp

		        	<div class="col-md-4">
				        <div class="form-group">
				            {!! Form::label('custom_field_2', $label_2 ) !!}
				            {!! Form::text('custom_field_2', null, ['class' => 'form-control','placeholder' => $custom_field_2_label, 'required' => $is_custom_field_2_required]); !!}
				        </div>
				    </div>
		        @endif
		        @if(!empty($custom_field_3_label))
		        	@php
		        		$label_3 = $custom_field_3_label . ':';
		        		if($is_custom_field_3_required) {
		        			$label_3 .= '*';
		        		}
		        	@endphp

		        	<div class="col-md-4">
				        <div class="form-group">
				            {!! Form::label('custom_field_3', $label_3 ) !!}
				            {!! Form::text('custom_field_3', null, ['class' => 'form-control','placeholder' => $custom_field_3_label, 'required' => $is_custom_field_3_required]); !!}
				        </div>
				    </div>
		        @endif
		        @if(!empty($custom_field_4_label))
		        	@php
		        		$label_4 = $custom_field_4_label . ':';
		        		if($is_custom_field_4_required) {
		        			$label_4 .= '*';
		        		}
		        	@endphp

		        	<div class="col-md-4">
				        <div class="form-group">
				            {!! Form::label('custom_field_4', $label_4 ) !!}
				            {!! Form::text('custom_field_4', null, ['class' => 'form-control','placeholder' => $custom_field_4_label, 'required' => $is_custom_field_4_required]); !!}
				        </div>
				    </div>
		        @endif
		        <div class="col-sm-3">
	                <div class="form-group">
	                    {!! Form::label('upload_document', __('purchase.attach_document') . ':') !!}
	                    {!! Form::file('sell_document', ['id' => 'upload_document', 'accept' => implode(',', array_keys(config('constants.document_upload_mimes_types')))]); !!}
	                    <p class="help-block">
	                    	@lang('purchase.max_file_size', ['size' => (config('constants.document_size_limit') / 1000000)])
	                    	@includeIf('components.document_help_text')
	                    </p>
	                </div>
	            </div>
		        <div class="clearfix"></div>

		        @if((!empty($pos_settings['enable_sales_order']) && $sale_type != 'sales_order') || $is_order_request_enabled)
					<div class="col-sm-3">
						<div class="form-group">
							{!! Form::label('sales_order_ids', __('lang_v1.sales_order').':') !!}
							{!! Form::select('sales_order_ids[]', [], null, ['class' => 'form-control select2', 'multiple', 'id' => 'sales_order_ids']); !!}
						</div>
					</div>
					<div class="clearfix"></div>
				@endif
				<!-- Call restaurant module if defined -->
		        @if(in_array('tables' ,$enabled_modules) || in_array('service_staff' ,$enabled_modules))
		        	<span id="restaurant_module_span">
		        	</span>
		        @endif
			@endcomponent

			@component('components.widget', ['class' => 'box-solid'])
				<div class="col-sm-10 col-sm-offset-1">
					<div class="form-group">
						<div class="input-group">
							<div class="input-group-btn">
								<button type="button" class="btn btn-default bg-white btn-flat" data-toggle="modal" data-target="#configure_search_modal" title="{{__('lang_v1.configure_product_search')}}"><i class="fas fa-search-plus"></i></button>
							</div>
							{!! Form::text('search_product', null, ['class' => 'form-control mousetrap', 'id' => 'search_product', 'placeholder' => __('lang_v1.search_product_placeholder'),
							'disabled' => is_null($default_location)? true : false,
							'autofocus' => is_null($default_location)? false : true,
							]); !!}
							<span class="input-group-btn">
								<button type="button" class="btn btn-default bg-white btn-flat pos_add_quick_product" data-href="{{action([\App\Http\Controllers\ProductController::class, 'quickAdd'])}}" data-container=".quick_add_product_modal"><i class="fa fa-plus-circle text-primary fa-lg"></i></button>
							</span>
						</div>
					</div>
				</div>

				<div class="row col-sm-12 pos_product_div" style="min-height: 0">

					<input type="hidden" name="sell_price_tax" id="sell_price_tax" value="{{$business_details->sell_price_tax}}">

					<!-- Keeps count of product rows -->
					<input type="hidden" id="product_row_count" 
						value="0">
					@php
						$hide_tax = '';
						if( session()->get('business.enable_inline_tax') == 0){
							$hide_tax = 'hide';
						}
					@endphp
					<div class="table-responsive">
					<table class="table table-condensed table-bordered table-striped table-responsive" id="pos_table">
						<thead>
							<tr>
								<th class="text-center">	
									@lang('sale.product')
								</th>
								<th class="text-center">
									@lang('sale.qty')
								</th>
								@if(!empty($pos_settings['inline_service_staff']))
									<th class="text-center">
										@lang('restaurant.service_staff')
									</th>
								@endif
								<th class="@if(!auth()->user()->can('edit_product_price_from_sale_screen')) hide @endif">
									@lang('sale.unit_price')
								</th>
								<th class="@if(!auth()->user()->can('edit_product_discount_from_sale_screen')) hide @endif">
									@lang('receipt.discount')
								</th>
								<th class="text-center {{$hide_tax}}">
									@lang('sale.tax')
								</th>
								<th class="text-center {{$hide_tax}}">
									@lang('sale.price_inc_tax')
								</th>
								@if(!empty($common_settings['enable_product_warranty']))
									<th>@lang('lang_v1.warranty')</th>
								@endif
								<th class="text-center">
									@lang('sale.subtotal')
								</th>
								<th class="text-center"><i class="fas fa-times" aria-hidden="true"></i></th>
							</tr>
						</thead>
						<tbody></tbody>
					</table>
					</div>
					<div class="table-responsive">
					<table class="table table-condensed table-bordered table-striped">
						<tr>
							<td>
								<div class="pull-right">
								<b>@lang('sale.item'):</b> 
								<span class="total_quantity">0</span>
								&nbsp;&nbsp;&nbsp;&nbsp;
								<b>@lang('sale.total'): </b>
									<span class="price_total">0</span>
								</div>
							</td>
						</tr>
					</table>
					</div>
				</div>
			@endcomponent
			@component('components.widget', ['class' => 'box-solid'])
				<div class="col-md-4  @if($sale_type == 'sales_order') hide @endif">
			        <div class="form-group">
			            {!! Form::label('discount_type', __('sale.discount_type') . ':*' ) !!}
			            <div class="input-group">
			                <span class="input-group-addon">
			                    <i class="fa fa-info"></i>
			                </span>
			                {!! Form::select('discount_type', ['fixed' => __('lang_v1.fixed'), 'percentage' => __('lang_v1.percentage')], 'percentage' , ['class' => 'form-control','placeholder' => __('messages.please_select'), 'required', 'data-default' => 'percentage']); !!}
			            </div>
			        </div>
			    </div>
			    @php
			    	$max_discount = !is_null(auth()->user()->max_sales_discount_percent) ? auth()->user()->max_sales_discount_percent : '';

			    	//if sale discount is more than user max discount change it to max discount
			    	$sales_discount = $business_details->default_sales_discount;
			    	if($max_discount != '' && $sales_discount > $max_discount) $sales_discount = $max_discount;

			    	$default_sales_tax = $business_details->default_sales_tax;

			    	if($sale_type == 'sales_order') {
			    		$sales_discount = 0;
			    		$default_sales_tax = null;
			    	}
			    @endphp
			    <div class="col-md-4 @if($sale_type == 'sales_order') hide @endif">
			        <div class="form-group">
			            {!! Form::label('discount_amount', __('sale.discount_amount') . ':*' ) !!}
			            <div class="input-group">
			                <span class="input-group-addon">
			                    <i class="fa fa-info"></i>
			                </span>
			                {!! Form::text('discount_amount', @num_format($sales_discount), ['class' => 'form-control input_number', 'data-default' => $sales_discount, 'data-max-discount' => $max_discount, 'data-max-discount-error_msg' => __('lang_v1.max_discount_error_msg', ['discount' => $max_discount != '' ? @num_format($max_discount) : '']) ]); !!}
			            </div>
			        </div>
			    </div>
			    <div class="col-md-4 @if($sale_type == 'sales_order') hide @endif"><br>
			    	<b>@lang( 'sale.discount_amount' ):</b>(-) 
					<span class="display_currency" id="total_discount">0</span>
			    </div>
			    <div class="clearfix"></div>
			    <div class="col-md-12 well well-sm bg-light-gray @if(session('business.enable_rp') != 1 || $sale_type == 'sales_order') hide @endif">
			    	<input type="hidden" name="rp_redeemed" id="rp_redeemed" value="0">
			    	<input type="hidden" name="rp_redeemed_amount" id="rp_redeemed_amount" value="0">
			    	<div class="col-md-12"><h4>{{session('business.rp_name')}}</h4></div>
			    	<div class="col-md-4">
				        <div class="form-group">
				            {!! Form::label('rp_redeemed_modal', __('lang_v1.redeemed') . ':' ) !!}
				            <div class="input-group">
				                <span class="input-group-addon">
				                    <i class="fa fa-gift"></i>
				                </span>
				                {!! Form::number('rp_redeemed_modal', 0, ['class' => 'form-control direct_sell_rp_input', 'data-amount_per_unit_point' => session('business.redeem_amount_per_unit_rp'), 'min' => 0, 'data-max_points' => 0, 'data-min_order_total' => session('business.min_order_total_for_redeem') ]); !!}
				                <input type="hidden" id="rp_name" value="{{session('business.rp_name')}}">
				            </div>
				        </div>
				    </div>
				    <div class="col-md-4">
				    	<p><strong>@lang('lang_v1.available'):</strong> <span id="available_rp">0</span></p>
				    </div>
				    <div class="col-md-4">
				    	<p><strong>@lang('lang_v1.redeemed_amount'):</strong> (-)<span id="rp_redeemed_amount_text">0</span></p>
				    </div>
			    </div>
			    <div class="clearfix"></div>
			    <div class="col-md-4  @if($sale_type == 'sales_order') hide @endif">
			    	<div class="form-group">
			            {!! Form::label('tax_rate_id', __('sale.order_tax') . ':*' ) !!}
			            <div class="input-group">
			                <span class="input-group-addon">
			                    <i class="fa fa-info"></i>
			                </span>
			                {!! Form::select('tax_rate_id', $taxes['tax_rates'], $default_sales_tax, ['placeholder' => __('messages.please_select'), 'class' => 'form-control', 'data-default'=> $default_sales_tax], $taxes['attributes']); !!}

							<input type="hidden" name="tax_calculation_amount" id="tax_calculation_amount" 
							value="@if(empty($edit)) {{@num_format($business_details->tax_calculation_amount)}} @else {{@num_format($transaction->tax?->amount)}} @endif" data-default="{{$business_details->tax_calculation_amount}}">
			            </div>
			        </div>
			    </div>
			    <div class="col-md-4 col-md-offset-4  @if($sale_type == 'sales_order') hide @endif">
			    	<b>@lang( 'sale.order_tax' ):</b>(+) 
					<span class="display_currency" id="order_tax">0</span>
			    </div>				
				
			    <div class="col-md-12">
			    	<div class="form-group">
						{!! Form::label('sell_note',__('sale.sell_note')) !!}
						{!! Form::textarea('sale_note', null, ['class' => 'form-control', 'rows' => 3]); !!}
					</div>
			    </div>
				<input type="hidden" name="is_direct_sale" value="1">
			@endcomponent
			@component('components.widget', ['class' => 'box-solid'])
			<div class="col-md-4">
				<div class="form-group">
		            {!! Form::label('shipping_details', __('sale.shipping_details')) !!}
		            {!! Form::textarea('shipping_details',null, ['class' => 'form-control','placeholder' => __('sale.shipping_details') ,'rows' => '3', 'cols'=>'30']); !!}
		        </div>
			</div>
			<div class="col-md-4">
				<div class="form-group">
		            {!! Form::label('shipping_address', __('lang_v1.shipping_address')) !!}
		            {!! Form::textarea('shipping_address',null, ['class' => 'form-control','placeholder' => __('lang_v1.shipping_address') ,'rows' => '3', 'cols'=>'30']); !!}
		        </div>
			</div>
			<div class="col-md-4">
				<div class="form-group">
					{!!Form::label('shipping_charges', __('sale.shipping_charges'))!!}
					<div class="input-group">
					<span class="input-group-addon">
					<i class="fa fa-info"></i>
					</span>
					{!!Form::text('shipping_charges',@num_format(0.00),['class'=>'form-control input_number','placeholder'=> __('sale.shipping_charges')]);!!}
					</div>
				</div>
			</div>
			<div class="clearfix"></div>
			<div class="col-md-4">
				<div class="form-group">
		            {!! Form::label('shipping_status', __('lang_v1.shipping_status')) !!}
		            {!! Form::select('shipping_status',$shipping_statuses, null, ['class' => 'form-control','placeholder' => __('messages.please_select')]); !!}
		        </div>
			</div>
			<div class="col-md-4">
		        <div class="form-group">
		            {!! Form::label('delivered_to', __('lang_v1.delivered_to') . ':' ) !!}
		            {!! Form::text('delivered_to', null, ['class' => 'form-control','placeholder' => __('lang_v1.delivered_to')]); !!}
		        </div>
		    </div>
			<div class="col-md-4">
				<div class="form-group">
					{!! Form::label('delivery_person', __('lang_v1.delivery_person') . ':' ) !!}
					{!! Form::select('delivery_person', $users, null, ['class' => 'form-control select2','placeholder' => __('messages.please_select')]); !!}
				</div>
			</div>
		    @php
		        $shipping_custom_label_1 = !empty($custom_labels['shipping']['custom_field_1']) ? $custom_labels['shipping']['custom_field_1'] : '';

		        $is_shipping_custom_field_1_required = !empty($custom_labels['shipping']['is_custom_field_1_required']) && $custom_labels['shipping']['is_custom_field_1_required'] == 1 ? true : false;

		        $shipping_custom_label_2 = !empty($custom_labels['shipping']['custom_field_2']) ? $custom_labels['shipping']['custom_field_2'] : '';

		        $is_shipping_custom_field_2_required = !empty($custom_labels['shipping']['is_custom_field_2_required']) && $custom_labels['shipping']['is_custom_field_2_required'] == 1 ? true : false;

		        $shipping_custom_label_3 = !empty($custom_labels['shipping']['custom_field_3']) ? $custom_labels['shipping']['custom_field_3'] : '';
		        
		        $is_shipping_custom_field_3_required = !empty($custom_labels['shipping']['is_custom_field_3_required']) && $custom_labels['shipping']['is_custom_field_3_required'] == 1 ? true : false;

		        $shipping_custom_label_4 = !empty($custom_labels['shipping']['custom_field_4']) ? $custom_labels['shipping']['custom_field_4'] : '';
		        
		        $is_shipping_custom_field_4_required = !empty($custom_labels['shipping']['is_custom_field_4_required']) && $custom_labels['shipping']['is_custom_field_4_required'] == 1 ? true : false;

		        $shipping_custom_label_5 = !empty($custom_labels['shipping']['custom_field_5']) ? $custom_labels['shipping']['custom_field_5'] : '';
		        
		        $is_shipping_custom_field_5_required = !empty($custom_labels['shipping']['is_custom_field_5_required']) && $custom_labels['shipping']['is_custom_field_5_required'] == 1 ? true : false;
	        @endphp

	        @if(!empty($shipping_custom_label_1))
	        	@php
	        		$label_1 = $shipping_custom_label_1 . ':';
	        		if($is_shipping_custom_field_1_required) {
	        			$label_1 .= '*';
	        		}
	        	@endphp

	        	<div class="col-md-4">
			        <div class="form-group">
			            {!! Form::label('shipping_custom_field_1', $label_1 ) !!}
			            {!! Form::text('shipping_custom_field_1', !empty($walk_in_customer['shipping_custom_field_details']['shipping_custom_field_1']) ? $walk_in_customer['shipping_custom_field_details']['shipping_custom_field_1'] : null, ['class' => 'form-control','placeholder' => $shipping_custom_label_1, 'required' => $is_shipping_custom_field_1_required]); !!}
			        </div>
			    </div>
	        @endif
	        @if(!empty($shipping_custom_label_2))
	        	@php
	        		$label_2 = $shipping_custom_label_2 . ':';
	        		if($is_shipping_custom_field_2_required) {
	        			$label_2 .= '*';
	        		}
	        	@endphp

	        	<div class="col-md-4">
			        <div class="form-group">
			            {!! Form::label('shipping_custom_field_2', $label_2 ) !!}
			            {!! Form::text('shipping_custom_field_2', !empty($walk_in_customer['shipping_custom_field_details']['shipping_custom_field_2']) ? $walk_in_customer['shipping_custom_field_details']['shipping_custom_field_2'] : null, ['class' => 'form-control','placeholder' => $shipping_custom_label_2, 'required' => $is_shipping_custom_field_2_required]); !!}
			        </div>
			    </div>
	        @endif
	        @if(!empty($shipping_custom_label_3))
	        	@php
	        		$label_3 = $shipping_custom_label_3 . ':';
	        		if($is_shipping_custom_field_3_required) {
	        			$label_3 .= '*';
	        		}
	        	@endphp

	        	<div class="col-md-4">
			        <div class="form-group">
			            {!! Form::label('shipping_custom_field_3', $label_3 ) !!}
			            {!! Form::text('shipping_custom_field_3', !empty($walk_in_customer['shipping_custom_field_details']['shipping_custom_field_3']) ? $walk_in_customer['shipping_custom_field_details']['shipping_custom_field_3'] : null, ['class' => 'form-control','placeholder' => $shipping_custom_label_3, 'required' => $is_shipping_custom_field_3_required]); !!}
			        </div>
			    </div>
	        @endif
	        @if(!empty($shipping_custom_label_4))
	        	@php
	        		$label_4 = $shipping_custom_label_4 . ':';
	        		if($is_shipping_custom_field_4_required) {
	        			$label_4 .= '*';
	        		}
	        	@endphp

	        	<div class="col-md-4">
			        <div class="form-group">
			            {!! Form::label('shipping_custom_field_4', $label_4 ) !!}
			            {!! Form::text('shipping_custom_field_4', !empty($walk_in_customer['shipping_custom_field_details']['shipping_custom_field_4']) ? $walk_in_customer['shipping_custom_field_details']['shipping_custom_field_4'] : null, ['class' => 'form-control','placeholder' => $shipping_custom_label_4, 'required' => $is_shipping_custom_field_4_required]); !!}
			        </div>
			    </div>
	        @endif
	        @if(!empty($shipping_custom_label_5))
	        	@php
	        		$label_5 = $shipping_custom_label_5 . ':';
	        		if($is_shipping_custom_field_5_required) {
	        			$label_5 .= '*';
	        		}
	        	@endphp

	        	<div class="col-md-4">
			        <div class="form-group">
			            {!! Form::label('shipping_custom_field_5', $label_5 ) !!}
			            {!! Form::text('shipping_custom_field_5', !empty($walk_in_customer['shipping_custom_field_details']['shipping_custom_field_5']) ? $walk_in_customer['shipping_custom_field_details']['shipping_custom_field_5'] : null, ['class' => 'form-control','placeholder' => $shipping_custom_label_5, 'required' => $is_shipping_custom_field_5_required]); !!}
			        </div>
			    </div>
	        @endif
	        <div class="col-md-4">
                <div class="form-group">
                    {!! Form::label('shipping_documents', __('lang_v1.shipping_documents') . ':') !!}
                    {!! Form::file('shipping_documents[]', ['id' => 'shipping_documents', 'multiple', 'accept' => implode(',', array_keys(config('constants.document_upload_mimes_types')))]); !!}
                    <p class="help-block">
                    	@lang('purchase.max_file_size', ['size' => (config('constants.document_size_limit') / 1000000)])
                    	@includeIf('components.document_help_text')
                    </p>
                </div>
            </div>
	        <div class="clearfix"></div>
	        <div class="col-md-12 text-center">
				<button type="button" class="tw-dw-btn tw-dw-btn-primary tw-dw-btn-sm tw-text-white" id="toggle_additional_expense"> <i class="fas fa-plus"></i> @lang('lang_v1.add_additional_expenses') <i class="fas fa-chevron-down"></i></button>
			</div>
			<div class="col-md-8 col-md-offset-4" id="additional_expenses_div" style="display: none;">
				<table class="table table-condensed">
					<thead>
						<tr>
							<th>@lang('lang_v1.additional_expense_name')</th>
							<th>@lang('sale.amount')</th>
						</tr>
					</thead>
					<tbody>
						<tr>
							<td>
								{!! Form::text('additional_expense_key_1', null, ['class' => 'form-control', 'id' => 'additional_expense_key_1']); !!}
							</td>
							<td>
								{!! Form::text('additional_expense_value_1', 0, ['class' => 'form-control input_number', 'id' => 'additional_expense_value_1']); !!}
							</td>
						</tr>
						<tr>
							<td>
								{!! Form::text('additional_expense_key_2', null, ['class' => 'form-control', 'id' => 'additional_expense_key_2']); !!}
							</td>
							<td>
								{!! Form::text('additional_expense_value_2', 0, ['class' => 'form-control input_number', 'id' => 'additional_expense_value_2']); !!}
							</td>
						</tr>
						<tr>
							<td>
								{!! Form::text('additional_expense_key_3', null, ['class' => 'form-control', 'id' => 'additional_expense_key_3']); !!}
							</td>
							<td>
								{!! Form::text('additional_expense_value_3', 0, ['class' => 'form-control input_number', 'id' => 'additional_expense_value_3']); !!}
							</td>
						</tr>
						<tr>
							<td>
								{!! Form::text('additional_expense_key_4', null, ['class' => 'form-control', 'id' => 'additional_expense_key_4']); !!}
							</td>
							<td>
								{!! Form::text('additional_expense_value_4', 0, ['class' => 'form-control input_number', 'id' => 'additional_expense_value_4']); !!}
							</td>
						</tr>
					</tbody>
				</table>
			</div>
		    <div class="col-md-4 col-md-offset-8">
		    	@if(!empty($pos_settings['amount_rounding_method']) && $pos_settings['amount_rounding_method'] > 0)
		    	<small id="round_off"><br>(@lang('lang_v1.round_off'): <span id="round_off_text">0</span>)</small>
				<br/>
				<input type="hidden" name="round_off_amount" 
					id="round_off_amount" value=0>
				@endif
		    	<div><b>@lang('sale.total_payable'): </b>
					<input type="hidden" name="final_total" id="final_total_input">
					<span id="total_payable">0</span>
				</div>
		    </div>
			@endcomponent
		</div>
	</div>
	@if(!empty($common_settings['is_enabled_export']) && $sale_type != 'sales_order')
		@component('components.widget', ['class' => 'box-solid', 'title' => __('lang_v1.export')])
			<div class="col-md-12 mb-12">
                <div class="form-check">
                    <input type="checkbox" name="is_export" class="form-check-input" id="is_export" @if(!empty($walk_in_customer['is_export'])) checked @endif>
                    <label class="form-check-label" for="is_export">@lang('lang_v1.is_export')</label>
                </div>
            </div>
	        @php
	            $i = 1;
	        @endphp
	        @for($i; $i <= 6 ; $i++)
	            <div class="col-md-4 export_div" @if(empty($walk_in_customer['is_export'])) style="display: none;" @endif>
	                <div class="form-group">
	                    {!! Form::label('export_custom_field_'.$i, __('lang_v1.export_custom_field'.$i).':') !!}
	                    {!! Form::text('export_custom_fields_info['.'export_custom_field_'.$i.']', !empty($walk_in_customer['export_custom_field_'.$i]) ? $walk_in_customer['export_custom_field_'.$i] : null, ['class' => 'form-control','placeholder' => __('lang_v1.export_custom_field'.$i), 'id' => 'export_custom_field_'.$i]); !!}
	                </div>
	            </div>
	        @endfor
		@endcomponent
	@endif
	@php
		$is_enabled_download_pdf = config('constants.enable_download_pdf');
		$payment_body_id = 'payment_rows_div';
		if ($is_enabled_download_pdf) {
			$payment_body_id = '';
		}
	@endphp
	@if((empty($status) || (!in_array($status, ['quotation', 'draft'])) || $is_enabled_download_pdf) && $sale_type != 'sales_order')
		@can('sell.payments')
			@component('components.widget', ['class' => 'box-solid', 'id' => $payment_body_id, 'title' => __('purchase.add_payment')])
			@if($is_enabled_download_pdf)
				<div class="well row">
					<div class="col-md-6">
						<div class="form-group">
							{!! Form::label("prefer_payment_method" , __('lang_v1.prefer_payment_method') . ':') !!}
							@show_tooltip(__('lang_v1.this_will_be_shown_in_pdf'))
							<div class="input-group">
								<span class="input-group-addon">
									<i class="fas fa-money-bill-alt"></i>
								</span>
								{!! Form::select("prefer_payment_method", $payment_types, 'cash', ['class' => 'form-control','style' => 'width:100%;']); !!}
							</div>
						</div>
					</div>
					<div class="col-md-6">
						<div class="form-group">
							{!! Form::label("prefer_payment_account" , __('lang_v1.prefer_payment_account') . ':') !!}
							@show_tooltip(__('lang_v1.this_will_be_SHOWN_IN_pdf'))
							<div class="input-group">
								<span class="input-group-addon">
									<i class="fas fa-money-bill-alt"></i>
								</span>
								{!! Form::select("prefer_payment_account", $accounts, null, ['class' => 'form-control','style' => 'width:100%;']); !!}
							</div>
						</div>
					</div>
				</div>
			@endif
			@if(empty($status) || !in_array($status, ['quotation', 'draft']))
				<div class="payment_row" @if($is_enabled_download_pdf) id="payment_rows_div" @endif>
					<div class="row">
						<div class="col-md-12 mb-12">
							<strong>@lang('lang_v1.advance_balance'):</strong> <span id="advance_balance_text"></span>
							{!! Form::hidden('advance_balance', null, ['id' => 'advance_balance', 'data-error-msg' => __('lang_v1.required_advance_balance_not_available')]); !!}
						</div>
					</div>
					@include('sale_pos.partials.payment_row_form', ['row_index' => 0, 'show_date' => true, 'show_denomination' => true])
                </div>
                <div class="payment_row">
					<div class="row">
						<div class="col-md-12">
			        		<hr>
			        		<strong>
			        			@lang('lang_v1.change_return'):
			        		</strong>
			        		<br/>
			        		<span class="lead text-bold change_return_span">0</span>
			        		{!! Form::hidden("change_return", $change_return['amount'], ['class' => 'form-control change_return input_number', 'required', 'id' => "change_return"]); !!}
			        		<!-- <span class="lead text-bold total_quantity">0</span> -->
			        		@if(!empty($change_return['id']))
			            		<input type="hidden" name="change_return_id" 
			            		value="{{$change_return['id']}}">
			            	@endif
						</div>
					</div>
					<div class="row hide payment_row" id="change_return_payment_data">
						<div class="col-md-4">
							<div class="form-group">
								{!! Form::label("change_return_method" , __('lang_v1.change_return_payment_method') . ':*') !!}
								<div class="input-group">
									<span class="input-group-addon">
										<i class="fas fa-money-bill-alt"></i>
									</span>
									@php
										$_payment_method = empty($change_return['method']) && array_key_exists('cash', $payment_types) ? 'cash' : $change_return['method'];

										$_payment_types = $payment_types;
										if(isset($_payment_types['advance'])) {
											unset($_payment_types['advance']);
										}
									@endphp
									{!! Form::select("payment[change_return][method]", $_payment_types, $_payment_method, ['class' => 'form-control col-md-12 payment_types_dropdown', 'id' => 'change_return_method', 'style' => 'width:100%;']); !!}
								</div>
							</div>
						</div>
						@if(!empty($accounts))
						<div class="col-md-4">
							<div class="form-group">
								{!! Form::label("change_return_account" , __('lang_v1.change_return_payment_account') . ':') !!}
								<div class="input-group">
									<span class="input-group-addon">
										<i class="fas fa-money-bill-alt"></i>
									</span>
									{!! Form::select("payment[change_return][account_id]", $accounts, !empty($change_return['account_id']) ? $change_return['account_id'] : '' , ['class' => 'form-control select2', 'id' => 'change_return_account', 'style' => 'width:100%;']); !!}
								</div>
							</div>
						</div>
						@endif
						@include('sale_pos.partials.payment_type_details', ['payment_line' => $change_return, 'row_index' => 'change_return'])
					</div>
					<hr>
					<div class="row">
						<div class="col-sm-12">
							<div class="pull-right"><strong>@lang('lang_v1.balance'):</strong> <span class="balance_due">0.00</span></div>
						</div>
					</div>
				</div>
			@endif
			@endcomponent
		@endcan
	@endif
	
	<div class="row">
		{!! Form::hidden('is_save_and_print', 0, ['id' => 'is_save_and_print']); !!}
		<input type="hidden" name="all_lots_selected" id="all_lots_selected" value="1">
		<div class="col-sm-12 text-center tw-mt-4">
			<button type="button" id="submit-sell" class="tw-dw-btn tw-dw-btn-primary tw-dw-btn-lg tw-text-white">@lang('messages.save')</button>
			<button type="button" id="save-and-print" class="tw-dw-btn tw-dw-btn-success tw-dw-btn-lg tw-text-white">@lang('lang_v1.save_and_print')</button>
		</div>
	</div>
	
	@if(empty($pos_settings['disable_recurring_invoice']))
		@include('sale_pos.partials.recurring_invoice_modal')
	@endif
	
	{!! Form::close() !!}
</section>

<div class="modal fade contact_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel">
	@include('contact.create', ['quick_add' => true])
</div>
<!-- /.content -->
<div class="modal fade register_details_modal" tabindex="-1" role="dialog" 
	aria-labelledby="gridSystemModalLabel">
</div>
<div class="modal fade close_register_modal" tabindex="-1" role="dialog" 
	aria-labelledby="gridSystemModalLabel">
</div>

<!-- quick product modal -->
<div class="modal fade quick_add_product_modal" tabindex="-1" role="dialog" aria-labelledby="modalTitle"></div>

<div class="modal fade types_of_service_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel"></div>


@include('sale_pos.partials.configure_search_modal')
@stop

@section('javascript')
	<script src="{{ asset('js/pos.js?v=' . ($asset_v ?? time())) }}"></script>
	<script src="{{ asset('js/product.js?v=' . $asset_v) }}"></script>
	<script src="{{ asset('js/opening_stock.js?v=' . $asset_v) }}"></script>

	@if(in_array('tables' ,$enabled_modules) || in_array('modifiers' ,$enabled_modules) || in_array('service_staff' ,$enabled_modules))
		<script src="{{ asset('js/restaurant.js?v=' . $asset_v) }}"></script>
	@endif

	<script type="text/javascript">
	$(document).ready(function () {
		var customerQrEndpoint = "{{ url('/contacts/qr-code') }}";
		var customerLastPriceGroupUrl = "{{ url('/sells/get-last-price-group') }}";

		function applyCustomerLastPriceGroup(customerId) {
			if (!customerId || !customerLastPriceGroupUrl) {
				return;
			}

			var $priceGroup = $('#price_group');
			if (!$priceGroup.length) {
				return;
			}

			$.ajax({
				url: customerLastPriceGroupUrl + '/' + customerId,
				dataType: 'json',
			}).done(function (result) {
				if (!result || !result.price_group_id) {
					return;
				}
				$priceGroup.val(result.price_group_id).trigger('change');
			});
		}
		var customerQrRequest;

		function handleCustomerQrMessage(type, message) {
			var $error = $('#customer_qr_code_error');
			var $success = $('#customer_qr_code_success');

			if (type === 'error') {
				$error.removeClass('hide').text(message);
				$success.addClass('hide').text('');
			} else if (type === 'success') {
				$success.removeClass('hide').text(message);
				$error.addClass('hide').text('');
			} else {
				$error.addClass('hide').text('');
				$success.addClass('hide').text('');
			}
		}

		function selectCustomerFromQr(contact) {
			var $customerSelect = $('#customer_id');
			if (!$customerSelect.length || !contact || !contact.id) {
				return;
			}

			if (!$customerSelect.find('option[value="' + contact.id + '"]').length) {
				var option = new Option(contact.text, contact.id, true, true);
				$customerSelect.append(option);
			} else {
				$customerSelect.val(contact.id);
			}
			$customerSelect.trigger('change');
			$customerSelect.trigger({
				type: 'select2:select',
				params: {
					data: contact,
				},
			});
		}

		function fetchCustomerFromQr(code) {
			code = (code || '').trim();
			handleCustomerQrMessage();
			if (code === '') {
				return;
			}

			if (customerQrRequest && customerQrRequest.readyState !== 4) {
				customerQrRequest.abort();
			}

			customerQrRequest = $.ajax({
				method: 'GET',
				url: customerQrEndpoint + '/' + encodeURIComponent(code),
				dataType: 'json',
			})
				.done(function (contact) {
					if (!contact || !contact.id) {
						handleCustomerQrMessage('error', '{{ __("lang_v1.customer_qr_code_invalid") }}');
						return;
					}
					selectCustomerFromQr(contact);
					var message = contact.text ? contact.text + ' selected' : '{{ __("lang_v1.customer_qr_code") }}';
					handleCustomerQrMessage('success', message);
				})
				.fail(function (xhr) {
					var msg = '{{ __("lang_v1.customer_qr_code_invalid") }}';
					if (xhr.responseJSON && xhr.responseJSON.msg) {
						msg = xhr.responseJSON.msg;
					}
					handleCustomerQrMessage('error', msg);
				});
		}

		$('#customer_qr_code')
			.on('input', function () {
				handleCustomerQrMessage();
			})
			.on('keypress', function (e) {
				if (e.which === 13) {
					e.preventDefault();
					fetchCustomerFromQr($(this).val());
				}
			})
			.on('change', function () {
				fetchCustomerFromQr($(this).val());
			});

		$('#customer_qr_code_clear').on('click', function () {
			$('#customer_qr_code').val('').trigger('input').focus();
			handleCustomerQrMessage();
		});

		/* Ensure Price Group has a real "Please Select" and allow clearing */
		if ($('#price_group').length) {
			if (!$('#price_group option[value=""]').length) {
				$('#price_group').prepend(
					$('<option>', { value: '' }).text((window.LANG && LANG.please_select) || '{{ __("messages.please_select") }}')
				);
			}
			$('#price_group').select2({
				allowClear: true,
				placeholder: $('#price_group').data('placeholder') || (window.LANG && LANG.please_select) || '{{ __("messages.please_select") }}'
			});

			// --- lock search until price group chosen ---
			var $sp = $('#search_product');
			var $quickBtn = $('.pos_add_quick_product');

			function setSearchEnabled(enabled){
				if (!$sp.length) return;
				if (!$sp.data('orig-ph')) $sp.data('orig-ph', $sp.attr('placeholder'));
				if (enabled) {
					$sp.prop('disabled', false).attr('placeholder', $sp.data('orig-ph'));
					$quickBtn.prop('disabled', false);
				} else {
					$sp.prop('disabled', true).val('')
					   .attr('placeholder', (window.LANG && LANG.please_select) || 'Please select a price group first');
					$quickBtn.prop('disabled', true);
				}
			}
			// initial state on page load
			setSearchEnabled(!!$('#price_group').val());
			// ------------------------------------------------

            // helper to refresh prices of existing rows for a given group id
            function refreshRowPrice($row, groupId){
                var variation_id = $row.find('.row_variation_id').val();
                var location_id  = $('#location_id').val();
                if(!variation_id || !location_id) return;

                var is_direct_sell = ($('input[name="is_direct_sale"]').val() === '1');
                var is_sales_order = ($('#sale_type').length && $('#sale_type').val() === 'sales_order');
                var disable_qty_alert = $('#disable_qty_alert').length ? true : false;
                var is_draft = ($('#status').length && ($('#status').val()==='quotation' || $('#status').val()==='draft'));

                var endpointBase = "{{ url('/sells/pos/get_product_row') }}";
                $.ajax({
                    method: 'GET',
                    url: endpointBase + '/' + variation_id + '/' + location_id,
                    data: {
                        product_row: 0,
                        customer_id: $('#customer_id').val(),
                        is_direct_sell: is_direct_sell ? 1 : 0,
                        price_group: groupId || '',
                        quantity: 1,
                        is_sales_order: is_sales_order,
                        disable_qty_alert: disable_qty_alert,
                        is_draft: is_draft
                    },
                    dataType: 'json'
                }).done(function(res){
                    if(!res || !res.success) { if(window.console){ console.warn('PG refresh failed', res); } return; }
                    var $tmp = $('<table>'+res.html_content+'</table>');
                    var newInc = __read_number($tmp.find('input.pos_unit_price_inc_tax'));
                    var newEx  = __read_number($tmp.find('input.pos_unit_price'));

                    if(!isNaN(newInc)) {
                        var $inc = $row.find('input.pos_unit_price_inc_tax');
                        __write_number($inc, newInc);
                        $inc.attr('data-orig', __number_f(newInc));
                        $inc.trigger('change');
                    }
                    if($row.find('input.pos_unit_price').length && !isNaN(newEx)) {
                        var $ex = $row.find('input.pos_unit_price');
                        __write_number($ex, newEx);
                        $ex.attr('data-orig', __number_f(newEx));
                        $ex.trigger('change');
                    }

                    // recalc row + totals
                    if(typeof pos_each_row === 'function') pos_each_row($row);

                    // ensure line subtotal reflects new unit price immediately
                    try {
                        var qty = __read_number($row.find('input.pos_quantity, input.input_quantity').first());
                        if (!isNaN(qty)) {
                            var unitInc = __read_number($row.find('input.pos_unit_price_inc_tax'));
                            var line = (qty || 0) * (unitInc || 0);
                            __write_number($row.find('input.pos_line_total'), line);
                            var $subText = $row.find('span.pos_line_total_text');
                            if ($subText.length && typeof __number_f === 'function') {
                                $subText.text(__number_f(line));
                            }
                        }
                    } catch (e) {}
                    if(typeof round_row_to_iraqi_dinnar === 'function') round_row_to_iraqi_dinnar($row);
                    if(typeof pos_total_row === 'function') pos_total_row();
                    if(typeof __currency_convert_recursively === 'function') __currency_convert_recursively($row);
                });
            }

		$('#price_group').on('change', function () {
			// toggle search enable/disable whenever price group changes
			setSearchEnabled(!!$(this).val());

                if ($(this).val() === '') {
                    // Optional: place any reset logic here if needed
                }

                // refresh prices for all existing rows
                var groupId = $(this).val();
                $('#pos_table tbody tr.product_row').each(function(){
                    refreshRowPrice($(this), groupId);
                });
            });
            // on page load, if a group is already selected, refresh rows to match
            var initialGroup = $('#price_group').val();
            if(initialGroup){
                $('#pos_table tbody tr.product_row').each(function(){
                    refreshRowPrice($(this), initialGroup);
                });
            }
		}

		$('#status').change(function(){
			if ($(this).val() == 'final') {
				$('#payment_rows_div').removeClass('hide');
			} else {
				$('#payment_rows_div').addClass('hide');
			}
		});

		$('.paid_on').datetimepicker({
			format: moment_date_format + ' ' + moment_time_format,
			ignoreReadonly: true,
		});

		$('#shipping_documents').fileinput({
			showUpload: false,
			showPreview: false,
			browseLabel: LANG.file_browse_label,
			removeLabel: LANG.remove,
		});

		$(document).on('change', '#prefer_payment_method', function(e) {
			var default_accounts = $('select#select_location_id').length ?
				$('select#select_location_id').find(':selected').data('default_payment_accounts')
				: $('#location_id').data('default_payment_accounts');

			var payment_type = $(this).val();
			if (payment_type) {
				var default_account = default_accounts && default_accounts[payment_type]['account']
					? default_accounts[payment_type]['account'] : '';

				var account_dropdown = $('select#prefer_payment_account');
				if (account_dropdown.length && default_accounts) {
					account_dropdown.val(default_account);
					account_dropdown.change();
				}
			}
		});

		function setPreferredPaymentMethodDropdown() {
			var payment_settings = $('#location_id').data('default_payment_accounts');
			payment_settings = payment_settings ? payment_settings : [];
			var enabled_payment_types = [];
			for (var key in payment_settings) {
				if (payment_settings[key] && payment_settings[key]['is_enabled']) {
					enabled_payment_types.push(key);
				}
			}
			if (enabled_payment_types.length) {
				$("#prefer_payment_method > option").each(function () {
					if (enabled_payment_types.indexOf($(this).val()) != -1) {
						$(this).removeClass('hide');
					} else {
						$(this).addClass('hide');
					}
				});
			}
		}
		setPreferredPaymentMethodDropdown();

		$('#is_export').on('change', function () {
			if ($(this).is(':checked')) {
				$('div.export_div').show();
			} else {
				$('div.export_div').hide();
			}
		});

		if ($('.payment_types_dropdown').length) {
			$('.payment_types_dropdown').change();
		}

		/* ===============================
		 *  HARD BLOCKS & VALIDATIONS
		 *  - Require Lot & Expiry for quotations before qty
		 *  - OOS / NEGATIVE / ZERO guards
		 * =============================== */

		function $qtyInput($row) {
			return $row.find('input.pos_quantity, input.input_quantity, input.quantity, input[name*="[quantity]"]').first();
		}
        function getQty($row) {
            var $q = $qtyInput($row);
            var val = parseFloat($q.val());
            return isNaN(val) ? 0 : val;
        }
        function rowSubtotal($row) {
            var v = 0;
            var $in = $row.find('input.pos_line_total');
            if ($in.length) { v = parseFloat(($in.val()||'').toString().replace(/,/g,'')); }
            if (!v || isNaN(v)) {
                var t = ($row.find('span.pos_line_total_text').text()||'').replace(/[^0-9.\-]/g,'');
                v = parseFloat(t);
            }
            return isNaN(v) ? 0 : v;
        }
        function rowHasPositiveAmount($row) {
            var q = getQty($row);
            if (q > 0) return true;
            var up = parseFloat(($row.find('input.pos_unit_price_inc_tax').val()||'').toString().replace(/,/g,''));
            if (!isNaN(up) && up > 0 && rowSubtotal($row) > 0) return true;
            return rowSubtotal($row) > 0;
        }
		function setQty($row, val) {
			var $q = $qtyInput($row);
			$q.val(val).trigger('change');
		}
		var LOT_SELECTOR = 'select.lot_number, select.lot_no, select.lot_number_dropdown, select[name*="[lot_no_line_id]"], select[name*="[lot_no]"], select[name*="[lot_numbers]"]';
		function lotSelect($row) {
			return $row.find(LOT_SELECTOR).first();
		}
		function requiresLot($row) {
			// If a lot selector exists on the row, treat lot as required
			return lotSelect($row).length > 0;
		}
		function hasLotSelected($row) {
			var $sel = lotSelect($row);
			if (!$sel.length) return true; // not applicable
			var v = $sel.val();
			return v !== undefined && v !== null && (v + '').trim() !== '';
		}
		function getAvailableQty($row) {
			// Prefer the selected lot/expiry quantity when a lot dropdown exists
			var $lot = lotSelect($row);
			if ($lot.length) {
				var $opt = $lot.find('option:selected');
				if ($opt.length) {
					var lotAvail = parseFloat($opt.data('qty_available'));
					if (isFinite(lotAvail)) {
						return lotAvail;
					}
				}
			}

			// Fallbacks
			var dataAttr = $row.data('qty_available');
			if (dataAttr !== undefined) {
				var n = parseFloat(dataAttr);
				if (!isNaN(n)) return n;
			}
			var candidates = [
				'input.qty_available',
				'input[name*="[qty_available]"]',
				'input[name*="[stock]"]',
				'input[name*="[available_quantity]"]',
				'select.lot_number option:selected'
			];
			for (var i = 0; i < candidates.length; i++) {
				var $c = $row.find(candidates[i]).first();
				if ($c.length) {
					var v = parseFloat($c.data('qty_available'));
					if (!isNaN(v)) return v;
					v = parseFloat($c.val() || $c.data('available') || $c.text());
					if (!isNaN(v)) return v;
				}
			}
			return Number.POSITIVE_INFINITY;
		}

        $('#customer_id').on('select2:select', function(e) {
            var data = e.params ? e.params.data : null;
            if (!data) {
                return;
            }
            if (data.price_calculation_type !== 'selling_price_group') {
                applyCustomerLastPriceGroup(data.id);
            }
        });
		function normalizeQty($row) {
			var q = getQty($row);
			if (!isFinite(q) || q <= 0) {
				setQty($row, 1);
				q = 1;
			}
			var rounded = Math.max(1, Math.floor(q));
			if (rounded !== q) {
				setQty($row, rounded);
			}
			return rounded;
		}
        function isQuotationMode() {
            var $s = $('#status');
            return $s.length && ($s.val() === 'quotation');
        }
        function isDraftMode() {
            var $s = $('#status');
            return $s.length && ($s.val() === 'draft');
        }

        function validateRow($row, showToastr) {
            // Enforce Lot & Expiry selection before positive quantities in quotation mode
            if (isQuotationMode() && requiresLot($row) && !hasLotSelected($row)) {
                // visual cue
                lotSelect($row).addClass('is-invalid');
                var current = getQty($row);
                if (current > 0) {
                    // reset qty back to 0 and notify
                    setQty($row, 0);
                    if (showToastr !== false && typeof toastr !== 'undefined') {
                        toastr.error((LANG.lot_expiry_required || 'Please select Lot & Expiry first.'));
                    }
                }
                // focus lot selector to guide user
                var $ls = lotSelect($row);
                if ($ls.length) { $ls.focus(); }
                // Block only when user attempted a positive qty
                return current > 0 ? false : true;
            } else {
                // clear invalid state if previously applied
                lotSelect($row).removeClass('is-invalid');
            }

            var avail = getAvailableQty($row);
            // In quotation mode we allow adding items even if out of stock
            if (!isQuotationMode() && isFinite(avail) && avail <= 0) {
                if (showToastr !== false && typeof toastr !== 'undefined') {
                    toastr.error(LANG.out_of_stock || 'Product is out of stock.');
                } else {
                    alert('Product is out of stock.');
                }
                $row.remove();
                updateTotals();
                return false;
            }
            var qty = normalizeQty($row);
            if (!isQuotationMode() && isFinite(avail) && qty > avail) {
                if (showToastr !== false && typeof toastr !== 'undefined') {
                    toastr.error((LANG.quantity_error_msg_in_lot || 'Only {qty} units available.').replace('{qty}', avail));
                } else {
                    alert('Only ' + avail + ' units available.');
                }
                setQty($row, avail);
                updateTotals();
                return true;
            }
            return true;
        }
		function updateTotals() {
			$('#pos_table tbody tr.product_row').each(function () {
				var $q = $qtyInput($(this));
				if ($q.length) $q.trigger('change');
			});
		}
		var target = document.querySelector('#pos_table tbody');
		if (target) {
			var observer = new MutationObserver(function (mutationsList) {
				mutationsList.forEach(function (m) {
					m.addedNodes.forEach(function (node) {
						var $row = $(node).closest('tr.product_row');
						if ($row.length) {
							// If quotation and lot is required but not selected, force qty 0 immediately
							if (isQuotationMode() && requiresLot($row) && !hasLotSelected($row)) {
								setQty($row, 0);
							}
							validateRow($row, true);
						}
					});
				});
			});
			observer.observe(target, { childList: true });
		}
		$(document).on('input change', '#pos_table tbody input.pos_quantity, #pos_table tbody input.input_quantity, #pos_table tbody input.quantity, #pos_table tbody input[name*="[quantity]"]', function () {
			var $row = $(this).closest('tr.product_row');
			validateRow($row, true);
		});
		$(document).on('change', '#pos_table tbody ' + LOT_SELECTOR, function () {
			var $row = $(this).closest('tr.product_row');
			// If user picks a lot while in quotation mode and qty is 0, bump to 1
			if (isQuotationMode() && hasLotSelected($row)) {
				lotSelect($row).removeClass('is-invalid');
				if (getQty($row) <= 0) {
					setQty($row, 1);
				}
			}
			validateRow($row, true);
		});
        function blockIfInvalid() {
            var ok = true;
            var missingLot = false;
            var firstMissingLotRow = null;
            $('#pos_table tbody tr.product_row').each(function () {
                var $row = $(this);
                if (!validateRow($row, false)) {
                    ok = false;
                }
                // Enforce lot selection whenever a row has a lot dropdown and a positive amount
                if (requiresLot($row) && !hasLotSelected($row)) {
                    missingLot = true;
                    lotSelect($row).addClass('is-invalid');
                    if (!firstMissingLotRow) firstMissingLotRow = $row;
                }
            });

            var msg = null;
            if (!ok) {
                // if another validation already failed, show its default message later
                msg = LANG.out_of_stock || 'One or more items are out of stock.';
            }
            if (missingLot) {
                ok = false;
                msg = (LANG.lot_expiry_required_for_all || LANG.lot_expiry_required || 'Please select Lot & Expiry for all items.');
                if (firstMissingLotRow) {
                    try { $('html, body').animate({ scrollTop: firstMissingLotRow.offset().top - 120 }, 200); } catch(e) {}
                    var $ls = lotSelect(firstMissingLotRow);
                    if ($ls.length) { $ls.focus(); }
                }
            }
            return { ok: ok, msg: msg };
        }
        $('#add_sell_form').on('submit', function (e) {
            var res = blockIfInvalid();
            if (!res.ok) {
                e.preventDefault();
                if (typeof e.stopImmediatePropagation === 'function') { e.stopImmediatePropagation(); }
                var msg = res.msg || (LANG.validation_error || 'Please fix validation errors.');
                if (typeof toastr !== 'undefined') {
                    toastr.error(msg);
                } else {
                    alert(msg);
                }
                return false;
            }
        });
        $('#submit-sell, #save-and-print').on('click', function (e) {
            var res = blockIfInvalid();
            if (!res.ok) {
                e.preventDefault();
                if (typeof e.stopImmediatePropagation === 'function') { e.stopImmediatePropagation(); }
                var msg = res.msg || (LANG.validation_error || 'Please fix validation errors.');
                if (typeof toastr !== 'undefined') {
                    toastr.error(msg);
                } else {
                    alert(msg);
                }
                return false;
            }
        });
	});
</script>
@endsection
